# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class SearchOffboardingRequestBody(object):
    _types = {
        "employment_ids": List[str],
        "apply_initiating_time_start": str,
        "apply_initiating_time_end": str,
        "expected_offboarding_date_start": str,
        "expected_offboarding_date_end": str,
        "offboarding_date_start": str,
        "offboarding_date_end": str,
        "statuses": List[str],
        "reasons": List[str],
        "employee_reasons": List[str],
    }

    def __init__(self, d=None):
        self.employment_ids: Optional[List[str]] = None
        self.apply_initiating_time_start: Optional[str] = None
        self.apply_initiating_time_end: Optional[str] = None
        self.expected_offboarding_date_start: Optional[str] = None
        self.expected_offboarding_date_end: Optional[str] = None
        self.offboarding_date_start: Optional[str] = None
        self.offboarding_date_end: Optional[str] = None
        self.statuses: Optional[List[str]] = None
        self.reasons: Optional[List[str]] = None
        self.employee_reasons: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchOffboardingRequestBodyBuilder":
        return SearchOffboardingRequestBodyBuilder()


class SearchOffboardingRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._search_offboarding_request_body = SearchOffboardingRequestBody()

    def employment_ids(self, employment_ids: List[str]) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.employment_ids = employment_ids
        return self

    def apply_initiating_time_start(self, apply_initiating_time_start: str) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.apply_initiating_time_start = apply_initiating_time_start
        return self

    def apply_initiating_time_end(self, apply_initiating_time_end: str) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.apply_initiating_time_end = apply_initiating_time_end
        return self

    def expected_offboarding_date_start(self,
                                        expected_offboarding_date_start: str) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.expected_offboarding_date_start = expected_offboarding_date_start
        return self

    def expected_offboarding_date_end(self,
                                      expected_offboarding_date_end: str) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.expected_offboarding_date_end = expected_offboarding_date_end
        return self

    def offboarding_date_start(self, offboarding_date_start: str) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.offboarding_date_start = offboarding_date_start
        return self

    def offboarding_date_end(self, offboarding_date_end: str) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.offboarding_date_end = offboarding_date_end
        return self

    def statuses(self, statuses: List[str]) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.statuses = statuses
        return self

    def reasons(self, reasons: List[str]) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.reasons = reasons
        return self

    def employee_reasons(self, employee_reasons: List[str]) -> "SearchOffboardingRequestBodyBuilder":
        self._search_offboarding_request_body.employee_reasons = employee_reasons
        return self

    def build(self) -> "SearchOffboardingRequestBody":
        return self._search_offboarding_request_body
