# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .name import Name


class SecurityGroup(object):
    _types = {
        "id": str,
        "code": str,
        "name": Name,
        "active_status": int,
        "description": Name,
        "update_time": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.code: Optional[str] = None
        self.name: Optional[Name] = None
        self.active_status: Optional[int] = None
        self.description: Optional[Name] = None
        self.update_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SecurityGroupBuilder":
        return SecurityGroupBuilder()


class SecurityGroupBuilder(object):
    def __init__(self) -> None:
        self._security_group = SecurityGroup()

    def id(self, id: str) -> "SecurityGroupBuilder":
        self._security_group.id = id
        return self

    def code(self, code: str) -> "SecurityGroupBuilder":
        self._security_group.code = code
        return self

    def name(self, name: Name) -> "SecurityGroupBuilder":
        self._security_group.name = name
        return self

    def active_status(self, active_status: int) -> "SecurityGroupBuilder":
        self._security_group.active_status = active_status
        return self

    def description(self, description: Name) -> "SecurityGroupBuilder":
        self._security_group.description = description
        return self

    def update_time(self, update_time: str) -> "SecurityGroupBuilder":
        self._security_group.update_time = update_time
        return self

    def build(self) -> "SecurityGroup":
        return self._security_group
