# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .object_field_data import ObjectFieldData


class SubmitOffboardingRequestBody(object):
    _types = {
        "offboarding_mode": int,
        "employment_id": str,
        "offboarding_date": str,
        "offboarding_reason_unique_identifier": str,
        "offboarding_reason_explanation": str,
        "initiator_id": str,
        "add_block_list": bool,
        "block_reason": str,
        "block_reason_explanation": str,
        "custom_fields": List[ObjectFieldData],
    }

    def __init__(self, d=None):
        self.offboarding_mode: Optional[int] = None
        self.employment_id: Optional[str] = None
        self.offboarding_date: Optional[str] = None
        self.offboarding_reason_unique_identifier: Optional[str] = None
        self.offboarding_reason_explanation: Optional[str] = None
        self.initiator_id: Optional[str] = None
        self.add_block_list: Optional[bool] = None
        self.block_reason: Optional[str] = None
        self.block_reason_explanation: Optional[str] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SubmitOffboardingRequestBodyBuilder":
        return SubmitOffboardingRequestBodyBuilder()


class SubmitOffboardingRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._submit_offboarding_request_body = SubmitOffboardingRequestBody()

    def offboarding_mode(self, offboarding_mode: int) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.offboarding_mode = offboarding_mode
        return self

    def employment_id(self, employment_id: str) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.employment_id = employment_id
        return self

    def offboarding_date(self, offboarding_date: str) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.offboarding_date = offboarding_date
        return self

    def offboarding_reason_unique_identifier(self,
                                             offboarding_reason_unique_identifier: str) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.offboarding_reason_unique_identifier = offboarding_reason_unique_identifier
        return self

    def offboarding_reason_explanation(self,
                                       offboarding_reason_explanation: str) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.offboarding_reason_explanation = offboarding_reason_explanation
        return self

    def initiator_id(self, initiator_id: str) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.initiator_id = initiator_id
        return self

    def add_block_list(self, add_block_list: bool) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.add_block_list = add_block_list
        return self

    def block_reason(self, block_reason: str) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.block_reason = block_reason
        return self

    def block_reason_explanation(self, block_reason_explanation: str) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.block_reason_explanation = block_reason_explanation
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "SubmitOffboardingRequestBodyBuilder":
        self._submit_offboarding_request_body.custom_fields = custom_fields
        return self

    def build(self) -> "SubmitOffboardingRequestBody":
        return self._submit_offboarding_request_body
