# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class SubmitOffboardingResponseBody(object):
    _types = {
        "offboarding_id": str,
        "employment_id": str,
        "offboarding_reason_unique_identifier": str,
        "offboarding_date": str,
        "offboarding_reason_explanation": str,
        "add_block_list": bool,
        "block_reason": str,
        "block_reason_explanation": str,
        "created_time": str,
    }

    def __init__(self, d=None):
        self.offboarding_id: Optional[str] = None
        self.employment_id: Optional[str] = None
        self.offboarding_reason_unique_identifier: Optional[str] = None
        self.offboarding_date: Optional[str] = None
        self.offboarding_reason_explanation: Optional[str] = None
        self.add_block_list: Optional[bool] = None
        self.block_reason: Optional[str] = None
        self.block_reason_explanation: Optional[str] = None
        self.created_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SubmitOffboardingResponseBodyBuilder":
        return SubmitOffboardingResponseBodyBuilder()


class SubmitOffboardingResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._submit_offboarding_response_body = SubmitOffboardingResponseBody()

    def offboarding_id(self, offboarding_id: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.offboarding_id = offboarding_id
        return self

    def employment_id(self, employment_id: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.employment_id = employment_id
        return self

    def offboarding_reason_unique_identifier(self,
                                             offboarding_reason_unique_identifier: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.offboarding_reason_unique_identifier = offboarding_reason_unique_identifier
        return self

    def offboarding_date(self, offboarding_date: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.offboarding_date = offboarding_date
        return self

    def offboarding_reason_explanation(self,
                                       offboarding_reason_explanation: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.offboarding_reason_explanation = offboarding_reason_explanation
        return self

    def add_block_list(self, add_block_list: bool) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.add_block_list = add_block_list
        return self

    def block_reason(self, block_reason: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.block_reason = block_reason
        return self

    def block_reason_explanation(self, block_reason_explanation: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.block_reason_explanation = block_reason_explanation
        return self

    def created_time(self, created_time: str) -> "SubmitOffboardingResponseBodyBuilder":
        self._submit_offboarding_response_body.created_time = created_time
        return self

    def build(self) -> "SubmitOffboardingResponseBody":
        return self._submit_offboarding_response_body
