# Code generated by Lark OpenAPI.

from typing import Any, Optional, IO

from lark_oapi.core.construct import init


class UploadPersonRequestBody(object):
    _types = {
        "file_content": IO[Any],
        "file_name": str,
    }

    def __init__(self, d=None):
        self.file_content: Optional[IO[Any]] = None
        self.file_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UploadPersonRequestBodyBuilder":
        return UploadPersonRequestBodyBuilder()


class UploadPersonRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._upload_person_request_body = UploadPersonRequestBody()

    def file_content(self, file_content: IO[Any]) -> "UploadPersonRequestBodyBuilder":
        self._upload_person_request_body.file_content = file_content
        return self

    def file_name(self, file_name: str) -> "UploadPersonRequestBodyBuilder":
        self._upload_person_request_body.file_name = file_name
        return self

    def build(self) -> "UploadPersonRequestBody":
        return self._upload_person_request_body
