# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .wk_calendar_i18n import WkCalendarI18n


class WorkCalendarDetail(object):
    _types = {
        "calendar_id": str,
        "calendar_name": WkCalendarI18n,
        "enable": bool,
    }

    def __init__(self, d=None):
        self.calendar_id: Optional[str] = None
        self.calendar_name: Optional[WkCalendarI18n] = None
        self.enable: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WorkCalendarDetailBuilder":
        return WorkCalendarDetailBuilder()


class WorkCalendarDetailBuilder(object):
    def __init__(self) -> None:
        self._work_calendar_detail = WorkCalendarDetail()

    def calendar_id(self, calendar_id: str) -> "WorkCalendarDetailBuilder":
        self._work_calendar_detail.calendar_id = calendar_id
        return self

    def calendar_name(self, calendar_name: WkCalendarI18n) -> "WorkCalendarDetailBuilder":
        self._work_calendar_detail.calendar_name = calendar_name
        return self

    def enable(self, enable: bool) -> "WorkCalendarDetailBuilder":
        self._work_calendar_detail.enable = enable
        return self

    def build(self) -> "WorkCalendarDetail":
        return self._work_calendar_detail
