# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n
from .object_field_data import ObjectFieldData


class WorkExperience(object):
    _types = {
        "company_organization": List[I18n],
        "department": List[I18n],
        "job": List[I18n],
        "description": List[I18n],
        "start_date": str,
        "end_date": str,
        "custom_fields": List[ObjectFieldData],
    }

    def __init__(self, d=None):
        self.company_organization: Optional[List[I18n]] = None
        self.department: Optional[List[I18n]] = None
        self.job: Optional[List[I18n]] = None
        self.description: Optional[List[I18n]] = None
        self.start_date: Optional[str] = None
        self.end_date: Optional[str] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WorkExperienceBuilder":
        return WorkExperienceBuilder()


class WorkExperienceBuilder(object):
    def __init__(self) -> None:
        self._work_experience = WorkExperience()

    def company_organization(self, company_organization: List[I18n]) -> "WorkExperienceBuilder":
        self._work_experience.company_organization = company_organization
        return self

    def department(self, department: List[I18n]) -> "WorkExperienceBuilder":
        self._work_experience.department = department
        return self

    def job(self, job: List[I18n]) -> "WorkExperienceBuilder":
        self._work_experience.job = job
        return self

    def description(self, description: List[I18n]) -> "WorkExperienceBuilder":
        self._work_experience.description = description
        return self

    def start_date(self, start_date: str) -> "WorkExperienceBuilder":
        self._work_experience.start_date = start_date
        return self

    def end_date(self, end_date: str) -> "WorkExperienceBuilder":
        self._work_experience.end_date = end_date
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "WorkExperienceBuilder":
        self._work_experience.custom_fields = custom_fields
        return self

    def build(self) -> "WorkExperience":
        return self._work_experience
