# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_contract_request import CreateContractRequest
from ..model.create_contract_response import CreateContractResponse
from ..model.delete_contract_request import DeleteContractRequest
from ..model.delete_contract_response import DeleteContractResponse
from ..model.get_contract_request import GetContractRequest
from ..model.get_contract_response import GetContractResponse
from ..model.list_contract_request import ListContractRequest
from ..model.list_contract_response import ListContractResponse
from ..model.patch_contract_request import PatchContractRequest
from ..model.patch_contract_response import PatchContractResponse


class Contract(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateContractRequest, option: Optional[RequestOption] = None) -> CreateContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateContractResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateContractResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateContractRequest,
                      option: Optional[RequestOption] = None) -> CreateContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateContractResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateContractResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteContractRequest, option: Optional[RequestOption] = None) -> DeleteContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteContractResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteContractResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteContractRequest,
                      option: Optional[RequestOption] = None) -> DeleteContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteContractResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteContractResponse)
        response.raw = resp

        return response

    def get(self, request: GetContractRequest, option: Optional[RequestOption] = None) -> GetContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetContractResponse = JSON.unmarshal(str(resp.content, UTF_8), GetContractResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetContractRequest, option: Optional[RequestOption] = None) -> GetContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetContractResponse = JSON.unmarshal(str(resp.content, UTF_8), GetContractResponse)
        response.raw = resp

        return response

    def list(self, request: ListContractRequest, option: Optional[RequestOption] = None) -> ListContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListContractResponse = JSON.unmarshal(str(resp.content, UTF_8), ListContractResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListContractRequest, option: Optional[RequestOption] = None) -> ListContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListContractResponse = JSON.unmarshal(str(resp.content, UTF_8), ListContractResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchContractRequest, option: Optional[RequestOption] = None) -> PatchContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchContractResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchContractResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchContractRequest,
                     option: Optional[RequestOption] = None) -> PatchContractResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchContractResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchContractResponse)
        response.raw = resp

        return response
