# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.get_country_region_request import GetCountryRegionRequest
from ..model.get_country_region_response import GetCountryRegionResponse
from ..model.list_country_region_request import ListCountryRegionRequest
from ..model.list_country_region_response import ListCountryRegionResponse


class CountryRegion(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def get(self, request: GetCountryRegionRequest, option: Optional[RequestOption] = None) -> GetCountryRegionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetCountryRegionResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCountryRegionResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetCountryRegionRequest,
                   option: Optional[RequestOption] = None) -> GetCountryRegionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetCountryRegionResponse = JSON.unmarshal(str(resp.content, UTF_8), GetCountryRegionResponse)
        response.raw = resp

        return response

    def list(self, request: ListCountryRegionRequest,
             option: Optional[RequestOption] = None) -> ListCountryRegionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListCountryRegionResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCountryRegionResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListCountryRegionRequest,
                    option: Optional[RequestOption] = None) -> ListCountryRegionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListCountryRegionResponse = JSON.unmarshal(str(resp.content, UTF_8), ListCountryRegionResponse)
        response.raw = resp

        return response
