# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.get_by_param_custom_field_request import GetByParamCustomFieldRequest
from ..model.get_by_param_custom_field_response import GetByParamCustomFieldResponse
from ..model.list_object_api_name_custom_field_request import ListObjectApiNameCustomFieldRequest
from ..model.list_object_api_name_custom_field_response import ListObjectApiNameCustomFieldResponse
from ..model.query_custom_field_request import QueryCustomFieldRequest
from ..model.query_custom_field_response import QueryCustomFieldResponse


class CustomField(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def get_by_param(self, request: GetByParamCustomFieldRequest,
                     option: Optional[RequestOption] = None) -> GetByParamCustomFieldResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetByParamCustomFieldResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 GetByParamCustomFieldResponse)
        response.raw = resp

        return response

    async def aget_by_param(self, request: GetByParamCustomFieldRequest,
                            option: Optional[RequestOption] = None) -> GetByParamCustomFieldResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetByParamCustomFieldResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                 GetByParamCustomFieldResponse)
        response.raw = resp

        return response

    def list_object_api_name(self, request: ListObjectApiNameCustomFieldRequest,
                             option: Optional[RequestOption] = None) -> ListObjectApiNameCustomFieldResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListObjectApiNameCustomFieldResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        ListObjectApiNameCustomFieldResponse)
        response.raw = resp

        return response

    async def alist_object_api_name(self, request: ListObjectApiNameCustomFieldRequest,
                                    option: Optional[RequestOption] = None) -> ListObjectApiNameCustomFieldResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListObjectApiNameCustomFieldResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        ListObjectApiNameCustomFieldResponse)
        response.raw = resp

        return response

    def query(self, request: QueryCustomFieldRequest,
              option: Optional[RequestOption] = None) -> QueryCustomFieldResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: QueryCustomFieldResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryCustomFieldResponse)
        response.raw = resp

        return response

    async def aquery(self, request: QueryCustomFieldRequest,
                     option: Optional[RequestOption] = None) -> QueryCustomFieldResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: QueryCustomFieldResponse = JSON.unmarshal(str(resp.content, UTF_8), QueryCustomFieldResponse)
        response.raw = resp

        return response
