# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_employment_request import CreateEmploymentRequest
from ..model.create_employment_response import CreateEmploymentResponse
from ..model.delete_employment_request import DeleteEmploymentRequest
from ..model.delete_employment_response import DeleteEmploymentResponse
from ..model.patch_employment_request import PatchEmploymentRequest
from ..model.patch_employment_response import PatchEmploymentResponse


class Employment(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateEmploymentRequest,
               option: Optional[RequestOption] = None) -> CreateEmploymentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateEmploymentResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateEmploymentResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateEmploymentRequest,
                      option: Optional[RequestOption] = None) -> CreateEmploymentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateEmploymentResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateEmploymentResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteEmploymentRequest,
               option: Optional[RequestOption] = None) -> DeleteEmploymentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteEmploymentResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteEmploymentResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteEmploymentRequest,
                      option: Optional[RequestOption] = None) -> DeleteEmploymentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteEmploymentResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteEmploymentResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchEmploymentRequest, option: Optional[RequestOption] = None) -> PatchEmploymentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchEmploymentResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchEmploymentResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchEmploymentRequest,
                     option: Optional[RequestOption] = None) -> PatchEmploymentResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchEmploymentResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchEmploymentResponse)
        response.raw = resp

        return response
