# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_job_data_request import CreateJobDataRequest
from ..model.create_job_data_response import CreateJobDataResponse
from ..model.delete_job_data_request import DeleteJobDataRequest
from ..model.delete_job_data_response import DeleteJobDataResponse
from ..model.get_job_data_request import GetJobDataRequest
from ..model.get_job_data_response import GetJobDataResponse
from ..model.list_job_data_request import ListJobDataRequest
from ..model.list_job_data_response import ListJobDataResponse
from ..model.patch_job_data_request import PatchJobDataRequest
from ..model.patch_job_data_response import PatchJobDataResponse


class JobData(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateJobDataRequest, option: Optional[RequestOption] = None) -> CreateJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateJobDataResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateJobDataRequest,
                      option: Optional[RequestOption] = None) -> CreateJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateJobDataResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteJobDataRequest, option: Optional[RequestOption] = None) -> DeleteJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteJobDataResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteJobDataRequest,
                      option: Optional[RequestOption] = None) -> DeleteJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteJobDataResponse)
        response.raw = resp

        return response

    def get(self, request: GetJobDataRequest, option: Optional[RequestOption] = None) -> GetJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), GetJobDataResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetJobDataRequest, option: Optional[RequestOption] = None) -> GetJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), GetJobDataResponse)
        response.raw = resp

        return response

    def list(self, request: ListJobDataRequest, option: Optional[RequestOption] = None) -> ListJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), ListJobDataResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListJobDataRequest, option: Optional[RequestOption] = None) -> ListJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), ListJobDataResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchJobDataRequest, option: Optional[RequestOption] = None) -> PatchJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchJobDataResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchJobDataRequest,
                     option: Optional[RequestOption] = None) -> PatchJobDataResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchJobDataResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchJobDataResponse)
        response.raw = resp

        return response
