# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.leave_balances_leave_request import LeaveBalancesLeaveRequest
from ..model.leave_balances_leave_response import LeaveBalancesLeaveResponse
from ..model.leave_request_history_leave_request import LeaveRequestHistoryLeaveRequest
from ..model.leave_request_history_leave_response import LeaveRequestHistoryLeaveResponse
from ..model.leave_types_leave_request import LeaveTypesLeaveRequest
from ..model.leave_types_leave_response import LeaveTypesLeaveResponse


class Leave(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def leave_balances(self, request: LeaveBalancesLeaveRequest,
                       option: Optional[RequestOption] = None) -> LeaveBalancesLeaveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: LeaveBalancesLeaveResponse = JSON.unmarshal(str(resp.content, UTF_8), LeaveBalancesLeaveResponse)
        response.raw = resp

        return response

    async def aleave_balances(self, request: LeaveBalancesLeaveRequest,
                              option: Optional[RequestOption] = None) -> LeaveBalancesLeaveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: LeaveBalancesLeaveResponse = JSON.unmarshal(str(resp.content, UTF_8), LeaveBalancesLeaveResponse)
        response.raw = resp

        return response

    def leave_request_history(self, request: LeaveRequestHistoryLeaveRequest,
                              option: Optional[RequestOption] = None) -> LeaveRequestHistoryLeaveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: LeaveRequestHistoryLeaveResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    LeaveRequestHistoryLeaveResponse)
        response.raw = resp

        return response

    async def aleave_request_history(self, request: LeaveRequestHistoryLeaveRequest,
                                     option: Optional[RequestOption] = None) -> LeaveRequestHistoryLeaveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: LeaveRequestHistoryLeaveResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    LeaveRequestHistoryLeaveResponse)
        response.raw = resp

        return response

    def leave_types(self, request: LeaveTypesLeaveRequest,
                    option: Optional[RequestOption] = None) -> LeaveTypesLeaveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: LeaveTypesLeaveResponse = JSON.unmarshal(str(resp.content, UTF_8), LeaveTypesLeaveResponse)
        response.raw = resp

        return response

    async def aleave_types(self, request: LeaveTypesLeaveRequest,
                           option: Optional[RequestOption] = None) -> LeaveTypesLeaveResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: LeaveTypesLeaveResponse = JSON.unmarshal(str(resp.content, UTF_8), LeaveTypesLeaveResponse)
        response.raw = resp

        return response
