# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_leave_granting_record_request import CreateLeaveGrantingRecordRequest
from ..model.create_leave_granting_record_response import CreateLeaveGrantingRecordResponse
from ..model.delete_leave_granting_record_request import DeleteLeaveGrantingRecordRequest
from ..model.delete_leave_granting_record_response import DeleteLeaveGrantingRecordResponse


class LeaveGrantingRecord(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateLeaveGrantingRecordRequest,
               option: Optional[RequestOption] = None) -> CreateLeaveGrantingRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateLeaveGrantingRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     CreateLeaveGrantingRecordResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateLeaveGrantingRecordRequest,
                      option: Optional[RequestOption] = None) -> CreateLeaveGrantingRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateLeaveGrantingRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     CreateLeaveGrantingRecordResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteLeaveGrantingRecordRequest,
               option: Optional[RequestOption] = None) -> DeleteLeaveGrantingRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteLeaveGrantingRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeleteLeaveGrantingRecordResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteLeaveGrantingRecordRequest,
                      option: Optional[RequestOption] = None) -> DeleteLeaveGrantingRecordResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteLeaveGrantingRecordResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeleteLeaveGrantingRecordResponse)
        response.raw = resp

        return response
