# Code generated by Lark OpenAPI.

from typing import Optional

from requests_toolbelt import MultipartEncoder

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from lark_oapi.core.utils import Files
from ..model.delete_person_request import DeletePersonRequest
from ..model.delete_person_response import DeletePersonResponse
from ..model.get_person_request import GetPersonRequest
from ..model.get_person_response import GetPersonResponse
from ..model.upload_person_request import UploadPersonRequest
from ..model.upload_person_response import UploadPersonResponse


class Person(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def delete(self, request: DeletePersonRequest, option: Optional[RequestOption] = None) -> DeletePersonResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeletePersonResponse = JSON.unmarshal(str(resp.content, UTF_8), DeletePersonResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeletePersonRequest,
                      option: Optional[RequestOption] = None) -> DeletePersonResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeletePersonResponse = JSON.unmarshal(str(resp.content, UTF_8), DeletePersonResponse)
        response.raw = resp

        return response

    def get(self, request: GetPersonRequest, option: Optional[RequestOption] = None) -> GetPersonResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetPersonResponse = JSON.unmarshal(str(resp.content, UTF_8), GetPersonResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetPersonRequest, option: Optional[RequestOption] = None) -> GetPersonResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetPersonResponse = JSON.unmarshal(str(resp.content, UTF_8), GetPersonResponse)
        response.raw = resp

        return response

    def upload(self, request: UploadPersonRequest, option: Optional[RequestOption] = None) -> UploadPersonResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            form_data = MultipartEncoder(Files.parse_form_data(request.body))
            request.body = form_data
            option.headers[CONTENT_TYPE] = form_data.content_type

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UploadPersonResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadPersonResponse)
        response.raw = resp

        return response

    async def aupload(self, request: UploadPersonRequest,
                      option: Optional[RequestOption] = None) -> UploadPersonResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 解析文件
        request.files = Files.extract_files(request.body)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UploadPersonResponse = JSON.unmarshal(str(resp.content, UTF_8), UploadPersonResponse)
        response.raw = resp

        return response
