# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n


class Bank(object):
    _types = {
        "bank_id": str,
        "bank_name": List[I18n],
        "bank_code": str,
        "country_region_id": str,
        "status": int,
    }

    def __init__(self, d=None):
        self.bank_id: Optional[str] = None
        self.bank_name: Optional[List[I18n]] = None
        self.bank_code: Optional[str] = None
        self.country_region_id: Optional[str] = None
        self.status: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BankBuilder":
        return BankBuilder()


class BankBuilder(object):
    def __init__(self) -> None:
        self._bank = Bank()

    def bank_id(self, bank_id: str) -> "BankBuilder":
        self._bank.bank_id = bank_id
        return self

    def bank_name(self, bank_name: List[I18n]) -> "BankBuilder":
        self._bank.bank_name = bank_name
        return self

    def bank_code(self, bank_code: str) -> "BankBuilder":
        self._bank.bank_code = bank_code
        return self

    def country_region_id(self, country_region_id: str) -> "BankBuilder":
        self._bank.country_region_id = country_region_id
        return self

    def status(self, status: int) -> "BankBuilder":
        self._bank.status = status
        return self

    def build(self) -> "Bank":
        return self._bank
