# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .basic_person_info import BasicPersonInfo


class BasicEmployee(object):
    _types = {
        "employment_id": str,
        "employee_number": str,
        "email_address": str,
        "person_info": BasicPersonInfo,
    }

    def __init__(self, d=None):
        self.employment_id: Optional[str] = None
        self.employee_number: Optional[str] = None
        self.email_address: Optional[str] = None
        self.person_info: Optional[BasicPersonInfo] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BasicEmployeeBuilder":
        return BasicEmployeeBuilder()


class BasicEmployeeBuilder(object):
    def __init__(self) -> None:
        self._basic_employee = BasicEmployee()

    def employment_id(self, employment_id: str) -> "BasicEmployeeBuilder":
        self._basic_employee.employment_id = employment_id
        return self

    def employee_number(self, employee_number: str) -> "BasicEmployeeBuilder":
        self._basic_employee.employee_number = employee_number
        return self

    def email_address(self, email_address: str) -> "BasicEmployeeBuilder":
        self._basic_employee.email_address = email_address
        return self

    def person_info(self, person_info: BasicPersonInfo) -> "BasicEmployeeBuilder":
        self._basic_employee.person_info = person_info
        return self

    def build(self) -> "BasicEmployee":
        return self._basic_employee
