# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .batch_get_company_request_body import BatchGetCompanyRequestBody


class BatchGetCompanyRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[BatchGetCompanyRequestBody] = None

    @staticmethod
    def builder() -> "BatchGetCompanyRequestBuilder":
        return BatchGetCompanyRequestBuilder()


class BatchGetCompanyRequestBuilder(object):

    def __init__(self) -> None:
        batch_get_company_request = BatchGetCompanyRequest()
        batch_get_company_request.http_method = HttpMethod.POST
        batch_get_company_request.uri = "/open-apis/corehr/v2/companies/batch_get"
        batch_get_company_request.token_types = {AccessTokenType.TENANT}
        self._batch_get_company_request: BatchGetCompanyRequest = batch_get_company_request

    def request_body(self, request_body: BatchGetCompanyRequestBody) -> "BatchGetCompanyRequestBuilder":
        self._batch_get_company_request.request_body = request_body
        self._batch_get_company_request.body = request_body
        return self

    def build(self) -> BatchGetCompanyRequest:
        return self._batch_get_company_request
