# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .batch_get_employee_request_body import BatchGetEmployeeRequestBody


class BatchGetEmployeeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.request_body: Optional[BatchGetEmployeeRequestBody] = None

    @staticmethod
    def builder() -> "BatchGetEmployeeRequestBuilder":
        return BatchGetEmployeeRequestBuilder()


class BatchGetEmployeeRequestBuilder(object):

    def __init__(self) -> None:
        batch_get_employee_request = BatchGetEmployeeRequest()
        batch_get_employee_request.http_method = HttpMethod.POST
        batch_get_employee_request.uri = "/open-apis/corehr/v2/employees/batch_get"
        batch_get_employee_request.token_types = {AccessTokenType.TENANT}
        self._batch_get_employee_request: BatchGetEmployeeRequest = batch_get_employee_request

    def user_id_type(self, user_id_type: str) -> "BatchGetEmployeeRequestBuilder":
        self._batch_get_employee_request.user_id_type = user_id_type
        self._batch_get_employee_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "BatchGetEmployeeRequestBuilder":
        self._batch_get_employee_request.department_id_type = department_id_type
        self._batch_get_employee_request.add_query("department_id_type", department_id_type)
        return self

    def request_body(self, request_body: BatchGetEmployeeRequestBody) -> "BatchGetEmployeeRequestBuilder":
        self._batch_get_employee_request.request_body = request_body
        self._batch_get_employee_request.body = request_body
        return self

    def build(self) -> BatchGetEmployeeRequest:
        return self._batch_get_employee_request
