# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class BatchGetEmployeeRequestBody(object):
    _types = {
        "fields": List[str],
        "employment_ids": List[str],
        "person_ids": List[str],
        "work_emails": List[str],
    }

    def __init__(self, d=None):
        self.fields: Optional[List[str]] = None
        self.employment_ids: Optional[List[str]] = None
        self.person_ids: Optional[List[str]] = None
        self.work_emails: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BatchGetEmployeeRequestBodyBuilder":
        return BatchGetEmployeeRequestBodyBuilder()


class BatchGetEmployeeRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._batch_get_employee_request_body = BatchGetEmployeeRequestBody()

    def fields(self, fields: List[str]) -> "BatchGetEmployeeRequestBodyBuilder":
        self._batch_get_employee_request_body.fields = fields
        return self

    def employment_ids(self, employment_ids: List[str]) -> "BatchGetEmployeeRequestBodyBuilder":
        self._batch_get_employee_request_body.employment_ids = employment_ids
        return self

    def person_ids(self, person_ids: List[str]) -> "BatchGetEmployeeRequestBodyBuilder":
        self._batch_get_employee_request_body.person_ids = person_ids
        return self

    def work_emails(self, work_emails: List[str]) -> "BatchGetEmployeeRequestBodyBuilder":
        self._batch_get_employee_request_body.work_emails = work_emails
        return self

    def build(self) -> "BatchGetEmployeeRequestBody":
        return self._batch_get_employee_request_body
