# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n


class CountryRegion(object):
    _types = {
        "country_region_id": str,
        "name": List[I18n],
        "full_name": List[I18n],
        "alpha_2_code": str,
        "alpha_3_code": str,
        "global_code": str,
        "status": int,
    }

    def __init__(self, d=None):
        self.country_region_id: Optional[str] = None
        self.name: Optional[List[I18n]] = None
        self.full_name: Optional[List[I18n]] = None
        self.alpha_2_code: Optional[str] = None
        self.alpha_3_code: Optional[str] = None
        self.global_code: Optional[str] = None
        self.status: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CountryRegionBuilder":
        return CountryRegionBuilder()


class CountryRegionBuilder(object):
    def __init__(self) -> None:
        self._country_region = CountryRegion()

    def country_region_id(self, country_region_id: str) -> "CountryRegionBuilder":
        self._country_region.country_region_id = country_region_id
        return self

    def name(self, name: List[I18n]) -> "CountryRegionBuilder":
        self._country_region.name = name
        return self

    def full_name(self, full_name: List[I18n]) -> "CountryRegionBuilder":
        self._country_region.full_name = full_name
        return self

    def alpha_2_code(self, alpha_2_code: str) -> "CountryRegionBuilder":
        self._country_region.alpha_2_code = alpha_2_code
        return self

    def alpha_3_code(self, alpha_3_code: str) -> "CountryRegionBuilder":
        self._country_region.alpha_3_code = alpha_3_code
        return self

    def global_code(self, global_code: str) -> "CountryRegionBuilder":
        self._country_region.global_code = global_code
        return self

    def status(self, status: int) -> "CountryRegionBuilder":
        self._country_region.status = status
        return self

    def build(self) -> "CountryRegion":
        return self._country_region
