# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .enum import Enum
from .i18n import I18n


class CountryRegionSubdivision(object):
    _types = {
        "country_region_subdivision_id": str,
        "name": List[I18n],
        "country_region_id": str,
        "subdivision_type": Enum,
        "iso_code": str,
        "status": int,
    }

    def __init__(self, d=None):
        self.country_region_subdivision_id: Optional[str] = None
        self.name: Optional[List[I18n]] = None
        self.country_region_id: Optional[str] = None
        self.subdivision_type: Optional[Enum] = None
        self.iso_code: Optional[str] = None
        self.status: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CountryRegionSubdivisionBuilder":
        return CountryRegionSubdivisionBuilder()


class CountryRegionSubdivisionBuilder(object):
    def __init__(self) -> None:
        self._country_region_subdivision = CountryRegionSubdivision()

    def country_region_subdivision_id(self, country_region_subdivision_id: str) -> "CountryRegionSubdivisionBuilder":
        self._country_region_subdivision.country_region_subdivision_id = country_region_subdivision_id
        return self

    def name(self, name: List[I18n]) -> "CountryRegionSubdivisionBuilder":
        self._country_region_subdivision.name = name
        return self

    def country_region_id(self, country_region_id: str) -> "CountryRegionSubdivisionBuilder":
        self._country_region_subdivision.country_region_id = country_region_id
        return self

    def subdivision_type(self, subdivision_type: Enum) -> "CountryRegionSubdivisionBuilder":
        self._country_region_subdivision.subdivision_type = subdivision_type
        return self

    def iso_code(self, iso_code: str) -> "CountryRegionSubdivisionBuilder":
        self._country_region_subdivision.iso_code = iso_code
        return self

    def status(self, status: int) -> "CountryRegionSubdivisionBuilder":
        self._country_region_subdivision.status = status
        return self

    def build(self) -> "CountryRegionSubdivision":
        return self._country_region_subdivision
