# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .cost_center import CostCenter


class CreateCostCenterRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[CostCenter] = None

    @staticmethod
    def builder() -> "CreateCostCenterRequestBuilder":
        return CreateCostCenterRequestBuilder()


class CreateCostCenterRequestBuilder(object):

    def __init__(self) -> None:
        create_cost_center_request = CreateCostCenterRequest()
        create_cost_center_request.http_method = HttpMethod.POST
        create_cost_center_request.uri = "/open-apis/corehr/v2/cost_centers"
        create_cost_center_request.token_types = {AccessTokenType.TENANT}
        self._create_cost_center_request: CreateCostCenterRequest = create_cost_center_request

    def user_id_type(self, user_id_type: str) -> "CreateCostCenterRequestBuilder":
        self._create_cost_center_request.user_id_type = user_id_type
        self._create_cost_center_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: CostCenter) -> "CreateCostCenterRequestBuilder":
        self._create_cost_center_request.request_body = request_body
        self._create_cost_center_request.body = request_body
        return self

    def build(self) -> CreateCostCenterRequest:
        return self._create_cost_center_request
