# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_probation_assessment_request_body import CreateProbationAssessmentRequestBody


class CreateProbationAssessmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[CreateProbationAssessmentRequestBody] = None

    @staticmethod
    def builder() -> "CreateProbationAssessmentRequestBuilder":
        return CreateProbationAssessmentRequestBuilder()


class CreateProbationAssessmentRequestBuilder(object):

    def __init__(self) -> None:
        create_probation_assessment_request = CreateProbationAssessmentRequest()
        create_probation_assessment_request.http_method = HttpMethod.POST
        create_probation_assessment_request.uri = "/open-apis/corehr/v2/probation/assessments"
        create_probation_assessment_request.token_types = {AccessTokenType.TENANT}
        self._create_probation_assessment_request: CreateProbationAssessmentRequest = create_probation_assessment_request

    def client_token(self, client_token: str) -> "CreateProbationAssessmentRequestBuilder":
        self._create_probation_assessment_request.client_token = client_token
        self._create_probation_assessment_request.add_query("client_token", client_token)
        return self

    def user_id_type(self, user_id_type: str) -> "CreateProbationAssessmentRequestBuilder":
        self._create_probation_assessment_request.user_id_type = user_id_type
        self._create_probation_assessment_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self,
                     request_body: CreateProbationAssessmentRequestBody) -> "CreateProbationAssessmentRequestBuilder":
        self._create_probation_assessment_request.request_body = request_body
        self._create_probation_assessment_request.body = request_body
        return self

    def build(self) -> CreateProbationAssessmentRequest:
        return self._create_probation_assessment_request
