# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .delete_cost_center_version_request_body import DeleteCostCenterVersionRequestBody


class DeleteCostCenterVersionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.cost_center_id: Optional[str] = None
        self.version_id: Optional[str] = None
        self.request_body: Optional[DeleteCostCenterVersionRequestBody] = None

    @staticmethod
    def builder() -> "DeleteCostCenterVersionRequestBuilder":
        return DeleteCostCenterVersionRequestBuilder()


class DeleteCostCenterVersionRequestBuilder(object):

    def __init__(self) -> None:
        delete_cost_center_version_request = DeleteCostCenterVersionRequest()
        delete_cost_center_version_request.http_method = HttpMethod.DELETE
        delete_cost_center_version_request.uri = "/open-apis/corehr/v2/cost_centers/:cost_center_id/versions/:version_id"
        delete_cost_center_version_request.token_types = {AccessTokenType.TENANT}
        self._delete_cost_center_version_request: DeleteCostCenterVersionRequest = delete_cost_center_version_request

    def cost_center_id(self, cost_center_id: str) -> "DeleteCostCenterVersionRequestBuilder":
        self._delete_cost_center_version_request.cost_center_id = cost_center_id
        self._delete_cost_center_version_request.paths["cost_center_id"] = str(cost_center_id)
        return self

    def version_id(self, version_id: str) -> "DeleteCostCenterVersionRequestBuilder":
        self._delete_cost_center_version_request.version_id = version_id
        self._delete_cost_center_version_request.paths["version_id"] = str(version_id)
        return self

    def request_body(self, request_body: DeleteCostCenterVersionRequestBody) -> "DeleteCostCenterVersionRequestBuilder":
        self._delete_cost_center_version_request.request_body = request_body
        self._delete_cost_center_version_request.body = request_body
        return self

    def build(self) -> DeleteCostCenterVersionRequest:
        return self._delete_cost_center_version_request
