# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class DeleteProbationAssessmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.assessment_id: Optional[str] = None

    @staticmethod
    def builder() -> "DeleteProbationAssessmentRequestBuilder":
        return DeleteProbationAssessmentRequestBuilder()


class DeleteProbationAssessmentRequestBuilder(object):

    def __init__(self) -> None:
        delete_probation_assessment_request = DeleteProbationAssessmentRequest()
        delete_probation_assessment_request.http_method = HttpMethod.DELETE
        delete_probation_assessment_request.uri = "/open-apis/corehr/v2/probation/assessments/:assessment_id"
        delete_probation_assessment_request.token_types = {AccessTokenType.TENANT}
        self._delete_probation_assessment_request: DeleteProbationAssessmentRequest = delete_probation_assessment_request

    def assessment_id(self, assessment_id: str) -> "DeleteProbationAssessmentRequestBuilder":
        self._delete_probation_assessment_request.assessment_id = assessment_id
        self._delete_probation_assessment_request.paths["assessment_id"] = str(assessment_id)
        return self

    def build(self) -> DeleteProbationAssessmentRequest:
        return self._delete_probation_assessment_request
