# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .reorganization_info import ReorganizationInfo


class DepartmentChange(object):
    _types = {
        "department_change_id": str,
        "department_id": str,
        "department_change_type": str,
        "reorganization_info": ReorganizationInfo,
    }

    def __init__(self, d=None):
        self.department_change_id: Optional[str] = None
        self.department_id: Optional[str] = None
        self.department_change_type: Optional[str] = None
        self.reorganization_info: Optional[ReorganizationInfo] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DepartmentChangeBuilder":
        return DepartmentChangeBuilder()


class DepartmentChangeBuilder(object):
    def __init__(self) -> None:
        self._department_change = DepartmentChange()

    def department_change_id(self, department_change_id: str) -> "DepartmentChangeBuilder":
        self._department_change.department_change_id = department_change_id
        return self

    def department_id(self, department_id: str) -> "DepartmentChangeBuilder":
        self._department_change.department_id = department_id
        return self

    def department_change_type(self, department_change_type: str) -> "DepartmentChangeBuilder":
        self._department_change.department_change_type = department_change_type
        return self

    def reorganization_info(self, reorganization_info: ReorganizationInfo) -> "DepartmentChangeBuilder":
        self._department_change.reorganization_info = reorganization_info
        return self

    def build(self) -> "DepartmentChange":
        return self._department_change
