# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class DepartmentHrbp(object):
    _types = {
        "department_id": str,
        "hrbp_ids": List[str],
    }

    def __init__(self, d=None):
        self.department_id: Optional[str] = None
        self.hrbp_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DepartmentHrbpBuilder":
        return DepartmentHrbpBuilder()


class DepartmentHrbpBuilder(object):
    def __init__(self) -> None:
        self._department_hrbp = DepartmentHrbp()

    def department_id(self, department_id: str) -> "DepartmentHrbpBuilder":
        self._department_hrbp.department_id = department_id
        return self

    def hrbp_ids(self, hrbp_ids: List[str]) -> "DepartmentHrbpBuilder":
        self._department_hrbp.hrbp_ids = hrbp_ids
        return self

    def build(self) -> "DepartmentHrbp":
        return self._department_hrbp
