# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n


class DepartmentParentInfo(object):
    _types = {
        "department_id": str,
        "department_name": List[I18n],
        "parent_department_id": str,
        "active": bool,
        "is_root": bool,
    }

    def __init__(self, d=None):
        self.department_id: Optional[str] = None
        self.department_name: Optional[List[I18n]] = None
        self.parent_department_id: Optional[str] = None
        self.active: Optional[bool] = None
        self.is_root: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DepartmentParentInfoBuilder":
        return DepartmentParentInfoBuilder()


class DepartmentParentInfoBuilder(object):
    def __init__(self) -> None:
        self._department_parent_info = DepartmentParentInfo()

    def department_id(self, department_id: str) -> "DepartmentParentInfoBuilder":
        self._department_parent_info.department_id = department_id
        return self

    def department_name(self, department_name: List[I18n]) -> "DepartmentParentInfoBuilder":
        self._department_parent_info.department_name = department_name
        return self

    def parent_department_id(self, parent_department_id: str) -> "DepartmentParentInfoBuilder":
        self._department_parent_info.parent_department_id = parent_department_id
        return self

    def active(self, active: bool) -> "DepartmentParentInfoBuilder":
        self._department_parent_info.active = active
        return self

    def is_root(self, is_root: bool) -> "DepartmentParentInfoBuilder":
        self._department_parent_info.is_root = is_root
        return self

    def build(self) -> "DepartmentParentInfo":
        return self._department_parent_info
