# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .department_parent_info import DepartmentParentInfo


class DepartmentParents(object):
    _types = {
        "department_id": str,
        "parent_department_list": List[DepartmentParentInfo],
    }

    def __init__(self, d=None):
        self.department_id: Optional[str] = None
        self.parent_department_list: Optional[List[DepartmentParentInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DepartmentParentsBuilder":
        return DepartmentParentsBuilder()


class DepartmentParentsBuilder(object):
    def __init__(self) -> None:
        self._department_parents = DepartmentParents()

    def department_id(self, department_id: str) -> "DepartmentParentsBuilder":
        self._department_parents.department_id = department_id
        return self

    def parent_department_list(self, parent_department_list: List[DepartmentParentInfo]) -> "DepartmentParentsBuilder":
        self._department_parents.parent_department_list = parent_department_list
        return self

    def build(self) -> "DepartmentParents":
        return self._department_parents
