# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .enum import Enum
from .i18n import I18n


class Dimension(object):
    _types = {
        "name": List[I18n],
        "api_name": str,
        "field_type": str,
        "required": bool,
        "enum_value": List[Enum],
    }

    def __init__(self, d=None):
        self.name: Optional[List[I18n]] = None
        self.api_name: Optional[str] = None
        self.field_type: Optional[str] = None
        self.required: Optional[bool] = None
        self.enum_value: Optional[List[Enum]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DimensionBuilder":
        return DimensionBuilder()


class DimensionBuilder(object):
    def __init__(self) -> None:
        self._dimension = Dimension()

    def name(self, name: List[I18n]) -> "DimensionBuilder":
        self._dimension.name = name
        return self

    def api_name(self, api_name: str) -> "DimensionBuilder":
        self._dimension.api_name = api_name
        return self

    def field_type(self, field_type: str) -> "DimensionBuilder":
        self._dimension.field_type = field_type
        return self

    def required(self, required: bool) -> "DimensionBuilder":
        self._dimension.required = required
        return self

    def enum_value(self, enum_value: List[Enum]) -> "DimensionBuilder":
        self._dimension.enum_value = enum_value
        return self

    def build(self) -> "Dimension":
        return self._dimension
