# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n


class DimensionInfo(object):
    _types = {
        "id": str,
        "name": List[I18n],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[List[I18n]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DimensionInfoBuilder":
        return DimensionInfoBuilder()


class DimensionInfoBuilder(object):
    def __init__(self) -> None:
        self._dimension_info = DimensionInfo()

    def id(self, id: str) -> "DimensionInfoBuilder":
        self._dimension_info.id = id
        return self

    def name(self, name: List[I18n]) -> "DimensionInfoBuilder":
        self._dimension_info.name = name
        return self

    def build(self) -> "DimensionInfo":
        return self._dimension_info
