# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .custom_value import CustomValue


class DimensionValue(object):
    _types = {
        "dimension_api_name": str,
        "dimension_value": CustomValue,
    }

    def __init__(self, d=None):
        self.dimension_api_name: Optional[str] = None
        self.dimension_value: Optional[CustomValue] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DimensionValueBuilder":
        return DimensionValueBuilder()


class DimensionValueBuilder(object):
    def __init__(self) -> None:
        self._dimension_value = DimensionValue()

    def dimension_api_name(self, dimension_api_name: str) -> "DimensionValueBuilder":
        self._dimension_value.dimension_api_name = dimension_api_name
        return self

    def dimension_value(self, dimension_value: CustomValue) -> "DimensionValueBuilder":
        self._dimension_value.dimension_value = dimension_value
        return self

    def build(self) -> "DimensionValue":
        return self._dimension_value
