# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class EducationInfo(object):
    _types = {
        "school_name": str,
        "education": str,
        "start_time": str,
        "end_time": str,
        "field_of_study": str,
    }

    def __init__(self, d=None):
        self.school_name: Optional[str] = None
        self.education: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.field_of_study: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EducationInfoBuilder":
        return EducationInfoBuilder()


class EducationInfoBuilder(object):
    def __init__(self) -> None:
        self._education_info = EducationInfo()

    def school_name(self, school_name: str) -> "EducationInfoBuilder":
        self._education_info.school_name = school_name
        return self

    def education(self, education: str) -> "EducationInfoBuilder":
        self._education_info.education = education
        return self

    def start_time(self, start_time: str) -> "EducationInfoBuilder":
        self._education_info.start_time = start_time
        return self

    def end_time(self, end_time: str) -> "EducationInfoBuilder":
        self._education_info.end_time = end_time
        return self

    def field_of_study(self, field_of_study: str) -> "EducationInfoBuilder":
        self._education_info.field_of_study = field_of_study
        return self

    def build(self) -> "EducationInfo":
        return self._education_info
