# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .address import Address
from .custom_field_data import CustomFieldData
from .email import Email
from .enum import Enum
from .person_name import PersonName
from .phone import Phone


class EmergencyContact(object):
    _types = {
        "name": PersonName,
        "relationship": Enum,
        "phone_ist": List[Phone],
        "phone_list": List[Phone],
        "legal_name": str,
        "custom_fields": List[CustomFieldData],
        "address": Address,
        "email": Email,
    }

    def __init__(self, d=None):
        self.name: Optional[PersonName] = None
        self.relationship: Optional[Enum] = None
        self.phone_ist: Optional[List[Phone]] = None
        self.phone_list: Optional[List[Phone]] = None
        self.legal_name: Optional[str] = None
        self.custom_fields: Optional[List[CustomFieldData]] = None
        self.address: Optional[Address] = None
        self.email: Optional[Email] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EmergencyContactBuilder":
        return EmergencyContactBuilder()


class EmergencyContactBuilder(object):
    def __init__(self) -> None:
        self._emergency_contact = EmergencyContact()

    def name(self, name: PersonName) -> "EmergencyContactBuilder":
        self._emergency_contact.name = name
        return self

    def relationship(self, relationship: Enum) -> "EmergencyContactBuilder":
        self._emergency_contact.relationship = relationship
        return self

    def phone_ist(self, phone_ist: List[Phone]) -> "EmergencyContactBuilder":
        self._emergency_contact.phone_ist = phone_ist
        return self

    def phone_list(self, phone_list: List[Phone]) -> "EmergencyContactBuilder":
        self._emergency_contact.phone_list = phone_list
        return self

    def legal_name(self, legal_name: str) -> "EmergencyContactBuilder":
        self._emergency_contact.legal_name = legal_name
        return self

    def custom_fields(self, custom_fields: List[CustomFieldData]) -> "EmergencyContactBuilder":
        self._emergency_contact.custom_fields = custom_fields
        return self

    def address(self, address: Address) -> "EmergencyContactBuilder":
        self._emergency_contact.address = address
        return self

    def email(self, email: Email) -> "EmergencyContactBuilder":
        self._emergency_contact.email = email
        return self

    def build(self) -> "EmergencyContact":
        return self._emergency_contact
