# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class EmploymentBp(object):
    _types = {
        "employment_id": str,
        "hrbp_ids": List[str],
        "location_bp_ids": List[str],
    }

    def __init__(self, d=None):
        self.employment_id: Optional[str] = None
        self.hrbp_ids: Optional[List[str]] = None
        self.location_bp_ids: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EmploymentBpBuilder":
        return EmploymentBpBuilder()


class EmploymentBpBuilder(object):
    def __init__(self) -> None:
        self._employment_bp = EmploymentBp()

    def employment_id(self, employment_id: str) -> "EmploymentBpBuilder":
        self._employment_bp.employment_id = employment_id
        return self

    def hrbp_ids(self, hrbp_ids: List[str]) -> "EmploymentBpBuilder":
        self._employment_bp.hrbp_ids = hrbp_ids
        return self

    def location_bp_ids(self, location_bp_ids: List[str]) -> "EmploymentBpBuilder":
        self._employment_bp.location_bp_ids = location_bp_ids
        return self

    def build(self) -> "EmploymentBp":
        return self._employment_bp
