# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .enable_disable_assessment_probation_request_body import EnableDisableAssessmentProbationRequestBody


class EnableDisableAssessmentProbationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[EnableDisableAssessmentProbationRequestBody] = None

    @staticmethod
    def builder() -> "EnableDisableAssessmentProbationRequestBuilder":
        return EnableDisableAssessmentProbationRequestBuilder()


class EnableDisableAssessmentProbationRequestBuilder(object):

    def __init__(self) -> None:
        enable_disable_assessment_probation_request = EnableDisableAssessmentProbationRequest()
        enable_disable_assessment_probation_request.http_method = HttpMethod.POST
        enable_disable_assessment_probation_request.uri = "/open-apis/corehr/v2/probation/enable_disable_assessment"
        enable_disable_assessment_probation_request.token_types = {AccessTokenType.TENANT}
        self._enable_disable_assessment_probation_request: EnableDisableAssessmentProbationRequest = enable_disable_assessment_probation_request

    def request_body(self,
                     request_body: EnableDisableAssessmentProbationRequestBody) -> "EnableDisableAssessmentProbationRequestBuilder":
        self._enable_disable_assessment_probation_request.request_body = request_body
        self._enable_disable_assessment_probation_request.body = request_body
        return self

    def build(self) -> EnableDisableAssessmentProbationRequest:
        return self._enable_disable_assessment_probation_request
