# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .get_by_department_bp_request_body import GetByDepartmentBpRequestBody


class GetByDepartmentBpRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.request_body: Optional[GetByDepartmentBpRequestBody] = None

    @staticmethod
    def builder() -> "GetByDepartmentBpRequestBuilder":
        return GetByDepartmentBpRequestBuilder()


class GetByDepartmentBpRequestBuilder(object):

    def __init__(self) -> None:
        get_by_department_bp_request = GetByDepartmentBpRequest()
        get_by_department_bp_request.http_method = HttpMethod.POST
        get_by_department_bp_request.uri = "/open-apis/corehr/v2/bps/get_by_department"
        get_by_department_bp_request.token_types = {AccessTokenType.TENANT}
        self._get_by_department_bp_request: GetByDepartmentBpRequest = get_by_department_bp_request

    def user_id_type(self, user_id_type: str) -> "GetByDepartmentBpRequestBuilder":
        self._get_by_department_bp_request.user_id_type = user_id_type
        self._get_by_department_bp_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "GetByDepartmentBpRequestBuilder":
        self._get_by_department_bp_request.department_id_type = department_id_type
        self._get_by_department_bp_request.add_query("department_id_type", department_id_type)
        return self

    def request_body(self, request_body: GetByDepartmentBpRequestBody) -> "GetByDepartmentBpRequestBuilder":
        self._get_by_department_bp_request.request_body = request_body
        self._get_by_department_bp_request.body = request_body
        return self

    def build(self) -> GetByDepartmentBpRequest:
        return self._get_by_department_bp_request
