# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetProcessRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.process_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetProcessRequestBuilder":
        return GetProcessRequestBuilder()


class GetProcessRequestBuilder(object):

    def __init__(self) -> None:
        get_process_request = GetProcessRequest()
        get_process_request.http_method = HttpMethod.GET
        get_process_request.uri = "/open-apis/corehr/v2/processes/:process_id"
        get_process_request.token_types = {AccessTokenType.TENANT}
        self._get_process_request: GetProcessRequest = get_process_request

    def user_id_type(self, user_id_type: str) -> "GetProcessRequestBuilder":
        self._get_process_request.user_id_type = user_id_type
        self._get_process_request.add_query("user_id_type", user_id_type)
        return self

    def process_id(self, process_id: str) -> "GetProcessRequestBuilder":
        self._get_process_request.process_id = process_id
        self._get_process_request.paths["process_id"] = str(process_id)
        return self

    def build(self) -> GetProcessRequest:
        return self._get_process_request
