# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .dataengine_i18n import DataengineI18n
from .process_abstract_item import ProcessAbstractItem
from .process_cc_item import ProcessCcItem
from .process_done_item import ProcessDoneItem
from .process_link import ProcessLink
from .process_todo_item import ProcessTodoItem


class GetProcessResponseBody(object):
    _types = {
        "process_id": str,
        "status": int,
        "flow_template_id": str,
        "flow_template_name": DataengineI18n,
        "flow_definition_id": str,
        "flow_definition_name": DataengineI18n,
        "initiator_id": str,
        "initiator_name": DataengineI18n,
        "create_time": str,
        "complete_time": str,
        "start_links": ProcessLink,
        "abstracts": List[ProcessAbstractItem],
        "todos": List[ProcessTodoItem],
        "cc_list": List[ProcessCcItem],
        "done_list": List[ProcessDoneItem],
    }

    def __init__(self, d=None):
        self.process_id: Optional[str] = None
        self.status: Optional[int] = None
        self.flow_template_id: Optional[str] = None
        self.flow_template_name: Optional[DataengineI18n] = None
        self.flow_definition_id: Optional[str] = None
        self.flow_definition_name: Optional[DataengineI18n] = None
        self.initiator_id: Optional[str] = None
        self.initiator_name: Optional[DataengineI18n] = None
        self.create_time: Optional[str] = None
        self.complete_time: Optional[str] = None
        self.start_links: Optional[ProcessLink] = None
        self.abstracts: Optional[List[ProcessAbstractItem]] = None
        self.todos: Optional[List[ProcessTodoItem]] = None
        self.cc_list: Optional[List[ProcessCcItem]] = None
        self.done_list: Optional[List[ProcessDoneItem]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "GetProcessResponseBodyBuilder":
        return GetProcessResponseBodyBuilder()


class GetProcessResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._get_process_response_body = GetProcessResponseBody()

    def process_id(self, process_id: str) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.process_id = process_id
        return self

    def status(self, status: int) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.status = status
        return self

    def flow_template_id(self, flow_template_id: str) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.flow_template_id = flow_template_id
        return self

    def flow_template_name(self, flow_template_name: DataengineI18n) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.flow_template_name = flow_template_name
        return self

    def flow_definition_id(self, flow_definition_id: str) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.flow_definition_id = flow_definition_id
        return self

    def flow_definition_name(self, flow_definition_name: DataengineI18n) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.flow_definition_name = flow_definition_name
        return self

    def initiator_id(self, initiator_id: str) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.initiator_id = initiator_id
        return self

    def initiator_name(self, initiator_name: DataengineI18n) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.initiator_name = initiator_name
        return self

    def create_time(self, create_time: str) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.create_time = create_time
        return self

    def complete_time(self, complete_time: str) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.complete_time = complete_time
        return self

    def start_links(self, start_links: ProcessLink) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.start_links = start_links
        return self

    def abstracts(self, abstracts: List[ProcessAbstractItem]) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.abstracts = abstracts
        return self

    def todos(self, todos: List[ProcessTodoItem]) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.todos = todos
        return self

    def cc_list(self, cc_list: List[ProcessCcItem]) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.cc_list = cc_list
        return self

    def done_list(self, done_list: List[ProcessDoneItem]) -> "GetProcessResponseBodyBuilder":
        self._get_process_response_body.done_list = done_list
        return self

    def build(self) -> "GetProcessResponseBody":
        return self._get_process_response_body
