# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .enum import Enum
from .i18n import I18n


class InternationalAssignment(object):
    _types = {
        "id": str,
        "assignment_city_id": str,
        "assignment_company_id": str,
        "assignment_country_id": str,
        "assignment_reason": I18n,
        "effective_time": str,
        "start_assignment_process_id": str,
        "end_assignment_process_id": str,
        "expiration_time": str,
        "international_assignment_status": Enum,
        "international_assignment_type": Enum,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.assignment_city_id: Optional[str] = None
        self.assignment_company_id: Optional[str] = None
        self.assignment_country_id: Optional[str] = None
        self.assignment_reason: Optional[I18n] = None
        self.effective_time: Optional[str] = None
        self.start_assignment_process_id: Optional[str] = None
        self.end_assignment_process_id: Optional[str] = None
        self.expiration_time: Optional[str] = None
        self.international_assignment_status: Optional[Enum] = None
        self.international_assignment_type: Optional[Enum] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "InternationalAssignmentBuilder":
        return InternationalAssignmentBuilder()


class InternationalAssignmentBuilder(object):
    def __init__(self) -> None:
        self._international_assignment = InternationalAssignment()

    def id(self, id: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.id = id
        return self

    def assignment_city_id(self, assignment_city_id: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.assignment_city_id = assignment_city_id
        return self

    def assignment_company_id(self, assignment_company_id: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.assignment_company_id = assignment_company_id
        return self

    def assignment_country_id(self, assignment_country_id: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.assignment_country_id = assignment_country_id
        return self

    def assignment_reason(self, assignment_reason: I18n) -> "InternationalAssignmentBuilder":
        self._international_assignment.assignment_reason = assignment_reason
        return self

    def effective_time(self, effective_time: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.effective_time = effective_time
        return self

    def start_assignment_process_id(self, start_assignment_process_id: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.start_assignment_process_id = start_assignment_process_id
        return self

    def end_assignment_process_id(self, end_assignment_process_id: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.end_assignment_process_id = end_assignment_process_id
        return self

    def expiration_time(self, expiration_time: str) -> "InternationalAssignmentBuilder":
        self._international_assignment.expiration_time = expiration_time
        return self

    def international_assignment_status(self,
                                        international_assignment_status: Enum) -> "InternationalAssignmentBuilder":
        self._international_assignment.international_assignment_status = international_assignment_status
        return self

    def international_assignment_type(self, international_assignment_type: Enum) -> "InternationalAssignmentBuilder":
        self._international_assignment.international_assignment_type = international_assignment_type
        return self

    def build(self) -> "InternationalAssignment":
        return self._international_assignment
