# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .bp import Bp


class ListBpResponseBody(object):
    _types = {
        "items": List[Bp],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Bp]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListBpResponseBodyBuilder":
        return ListBpResponseBodyBuilder()


class ListBpResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_bp_response_body = ListBpResponseBody()

    def items(self, items: List[Bp]) -> "ListBpResponseBodyBuilder":
        self._list_bp_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListBpResponseBodyBuilder":
        self._list_bp_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListBpResponseBodyBuilder":
        self._list_bp_response_body.has_more = has_more
        return self

    def build(self) -> "ListBpResponseBody":
        return self._list_bp_response_body
