# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListProcessRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.modify_time_to: Optional[str] = None
        self.statuses: Optional[List[int]] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None
        self.modify_time_from: Optional[str] = None
        self.flow_definition_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListProcessRequestBuilder":
        return ListProcessRequestBuilder()


class ListProcessRequestBuilder(object):

    def __init__(self) -> None:
        list_process_request = ListProcessRequest()
        list_process_request.http_method = HttpMethod.GET
        list_process_request.uri = "/open-apis/corehr/v2/processes"
        list_process_request.token_types = {AccessTokenType.TENANT}
        self._list_process_request: ListProcessRequest = list_process_request

    def modify_time_to(self, modify_time_to: str) -> "ListProcessRequestBuilder":
        self._list_process_request.modify_time_to = modify_time_to
        self._list_process_request.add_query("modify_time_to", modify_time_to)
        return self

    def statuses(self, statuses: List[int]) -> "ListProcessRequestBuilder":
        self._list_process_request.statuses = statuses
        self._list_process_request.add_query("statuses", statuses)
        return self

    def page_token(self, page_token: str) -> "ListProcessRequestBuilder":
        self._list_process_request.page_token = page_token
        self._list_process_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListProcessRequestBuilder":
        self._list_process_request.page_size = page_size
        self._list_process_request.add_query("page_size", page_size)
        return self

    def modify_time_from(self, modify_time_from: str) -> "ListProcessRequestBuilder":
        self._list_process_request.modify_time_from = modify_time_from
        self._list_process_request.add_query("modify_time_from", modify_time_from)
        return self

    def flow_definition_id(self, flow_definition_id: str) -> "ListProcessRequestBuilder":
        self._list_process_request.flow_definition_id = flow_definition_id
        self._list_process_request.add_query("flow_definition_id", flow_definition_id)
        return self

    def build(self) -> ListProcessRequest:
        return self._list_process_request
