# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .address import Address
from .custom_field_data import CustomFieldData
from .enum import Enum
from .i18n import I18n


class LocationV2(object):
    _types = {
        "location_id": str,
        "parent_location_id": str,
        "names": List[I18n],
        "code": str,
        "active": bool,
        "location_usages": List[Enum],
        "addresses": List[Address],
        "working_hours_type_id": str,
        "effective_time": str,
        "expiration_time": str,
        "custom_fields": List[CustomFieldData],
        "locale": Enum,
        "time_zone_id": str,
        "display_language_id": str,
    }

    def __init__(self, d=None):
        self.location_id: Optional[str] = None
        self.parent_location_id: Optional[str] = None
        self.names: Optional[List[I18n]] = None
        self.code: Optional[str] = None
        self.active: Optional[bool] = None
        self.location_usages: Optional[List[Enum]] = None
        self.addresses: Optional[List[Address]] = None
        self.working_hours_type_id: Optional[str] = None
        self.effective_time: Optional[str] = None
        self.expiration_time: Optional[str] = None
        self.custom_fields: Optional[List[CustomFieldData]] = None
        self.locale: Optional[Enum] = None
        self.time_zone_id: Optional[str] = None
        self.display_language_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "LocationV2Builder":
        return LocationV2Builder()


class LocationV2Builder(object):
    def __init__(self) -> None:
        self._location_v2 = LocationV2()

    def location_id(self, location_id: str) -> "LocationV2Builder":
        self._location_v2.location_id = location_id
        return self

    def parent_location_id(self, parent_location_id: str) -> "LocationV2Builder":
        self._location_v2.parent_location_id = parent_location_id
        return self

    def names(self, names: List[I18n]) -> "LocationV2Builder":
        self._location_v2.names = names
        return self

    def code(self, code: str) -> "LocationV2Builder":
        self._location_v2.code = code
        return self

    def active(self, active: bool) -> "LocationV2Builder":
        self._location_v2.active = active
        return self

    def location_usages(self, location_usages: List[Enum]) -> "LocationV2Builder":
        self._location_v2.location_usages = location_usages
        return self

    def addresses(self, addresses: List[Address]) -> "LocationV2Builder":
        self._location_v2.addresses = addresses
        return self

    def working_hours_type_id(self, working_hours_type_id: str) -> "LocationV2Builder":
        self._location_v2.working_hours_type_id = working_hours_type_id
        return self

    def effective_time(self, effective_time: str) -> "LocationV2Builder":
        self._location_v2.effective_time = effective_time
        return self

    def expiration_time(self, expiration_time: str) -> "LocationV2Builder":
        self._location_v2.expiration_time = expiration_time
        return self

    def custom_fields(self, custom_fields: List[CustomFieldData]) -> "LocationV2Builder":
        self._location_v2.custom_fields = custom_fields
        return self

    def locale(self, locale: Enum) -> "LocationV2Builder":
        self._location_v2.locale = locale
        return self

    def time_zone_id(self, time_zone_id: str) -> "LocationV2Builder":
        self._location_v2.time_zone_id = time_zone_id
        return self

    def display_language_id(self, display_language_id: str) -> "LocationV2Builder":
        self._location_v2.display_language_id = display_language_id
        return self

    def build(self) -> "LocationV2":
        return self._location_v2
