# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Name(object):
    _types = {
        "full_name": str,
        "first_name": str,
        "middle_name": str,
        "name_primary": str,
        "local_first_name": str,
        "local_middle_name": str,
        "local_primary": str,
    }

    def __init__(self, d=None):
        self.full_name: Optional[str] = None
        self.first_name: Optional[str] = None
        self.middle_name: Optional[str] = None
        self.name_primary: Optional[str] = None
        self.local_first_name: Optional[str] = None
        self.local_middle_name: Optional[str] = None
        self.local_primary: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "NameBuilder":
        return NameBuilder()


class NameBuilder(object):
    def __init__(self) -> None:
        self._name = Name()

    def full_name(self, full_name: str) -> "NameBuilder":
        self._name.full_name = full_name
        return self

    def first_name(self, first_name: str) -> "NameBuilder":
        self._name.first_name = first_name
        return self

    def middle_name(self, middle_name: str) -> "NameBuilder":
        self._name.middle_name = middle_name
        return self

    def name_primary(self, name_primary: str) -> "NameBuilder":
        self._name.name_primary = name_primary
        return self

    def local_first_name(self, local_first_name: str) -> "NameBuilder":
        self._name.local_first_name = local_first_name
        return self

    def local_middle_name(self, local_middle_name: str) -> "NameBuilder":
        self._name.local_middle_name = local_middle_name
        return self

    def local_primary(self, local_primary: str) -> "NameBuilder":
        self._name.local_primary = local_primary
        return self

    def build(self) -> "Name":
        return self._name
