# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .job_data_cost_center import JobDataCostCenter
from .object_field_data import ObjectFieldData


class OfferInfo(object):
    _types = {
        "offer_id": str,
        "offer_hr_id": str,
        "department_id": str,
        "direct_leader_id": str,
        "job_id": str,
        "job_family_id": str,
        "job_level_id": str,
        "job_title": str,
        "probation_start_date": str,
        "probation_end_date": str,
        "contract_start_date": str,
        "contract_end_date": str,
        "onboarding_date": str,
        "onboarding_location_id": str,
        "office_location_id": str,
        "recruitment_type_id": str,
        "probation_period": str,
        "employee_type_id": str,
        "employment_type_id": str,
        "work_email": str,
        "duration_type_id": str,
        "signing_type_id": str,
        "entry_mode": str,
        "social_security_city_id": str,
        "contract_type": str,
        "company": str,
        "cost_center_rate": List[JobDataCostCenter],
        "job_grade_id": str,
        "custom_fields": List[ObjectFieldData],
    }

    def __init__(self, d=None):
        self.offer_id: Optional[str] = None
        self.offer_hr_id: Optional[str] = None
        self.department_id: Optional[str] = None
        self.direct_leader_id: Optional[str] = None
        self.job_id: Optional[str] = None
        self.job_family_id: Optional[str] = None
        self.job_level_id: Optional[str] = None
        self.job_title: Optional[str] = None
        self.probation_start_date: Optional[str] = None
        self.probation_end_date: Optional[str] = None
        self.contract_start_date: Optional[str] = None
        self.contract_end_date: Optional[str] = None
        self.onboarding_date: Optional[str] = None
        self.onboarding_location_id: Optional[str] = None
        self.office_location_id: Optional[str] = None
        self.recruitment_type_id: Optional[str] = None
        self.probation_period: Optional[str] = None
        self.employee_type_id: Optional[str] = None
        self.employment_type_id: Optional[str] = None
        self.work_email: Optional[str] = None
        self.duration_type_id: Optional[str] = None
        self.signing_type_id: Optional[str] = None
        self.entry_mode: Optional[str] = None
        self.social_security_city_id: Optional[str] = None
        self.contract_type: Optional[str] = None
        self.company: Optional[str] = None
        self.cost_center_rate: Optional[List[JobDataCostCenter]] = None
        self.job_grade_id: Optional[str] = None
        self.custom_fields: Optional[List[ObjectFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferInfoBuilder":
        return OfferInfoBuilder()


class OfferInfoBuilder(object):
    def __init__(self) -> None:
        self._offer_info = OfferInfo()

    def offer_id(self, offer_id: str) -> "OfferInfoBuilder":
        self._offer_info.offer_id = offer_id
        return self

    def offer_hr_id(self, offer_hr_id: str) -> "OfferInfoBuilder":
        self._offer_info.offer_hr_id = offer_hr_id
        return self

    def department_id(self, department_id: str) -> "OfferInfoBuilder":
        self._offer_info.department_id = department_id
        return self

    def direct_leader_id(self, direct_leader_id: str) -> "OfferInfoBuilder":
        self._offer_info.direct_leader_id = direct_leader_id
        return self

    def job_id(self, job_id: str) -> "OfferInfoBuilder":
        self._offer_info.job_id = job_id
        return self

    def job_family_id(self, job_family_id: str) -> "OfferInfoBuilder":
        self._offer_info.job_family_id = job_family_id
        return self

    def job_level_id(self, job_level_id: str) -> "OfferInfoBuilder":
        self._offer_info.job_level_id = job_level_id
        return self

    def job_title(self, job_title: str) -> "OfferInfoBuilder":
        self._offer_info.job_title = job_title
        return self

    def probation_start_date(self, probation_start_date: str) -> "OfferInfoBuilder":
        self._offer_info.probation_start_date = probation_start_date
        return self

    def probation_end_date(self, probation_end_date: str) -> "OfferInfoBuilder":
        self._offer_info.probation_end_date = probation_end_date
        return self

    def contract_start_date(self, contract_start_date: str) -> "OfferInfoBuilder":
        self._offer_info.contract_start_date = contract_start_date
        return self

    def contract_end_date(self, contract_end_date: str) -> "OfferInfoBuilder":
        self._offer_info.contract_end_date = contract_end_date
        return self

    def onboarding_date(self, onboarding_date: str) -> "OfferInfoBuilder":
        self._offer_info.onboarding_date = onboarding_date
        return self

    def onboarding_location_id(self, onboarding_location_id: str) -> "OfferInfoBuilder":
        self._offer_info.onboarding_location_id = onboarding_location_id
        return self

    def office_location_id(self, office_location_id: str) -> "OfferInfoBuilder":
        self._offer_info.office_location_id = office_location_id
        return self

    def recruitment_type_id(self, recruitment_type_id: str) -> "OfferInfoBuilder":
        self._offer_info.recruitment_type_id = recruitment_type_id
        return self

    def probation_period(self, probation_period: str) -> "OfferInfoBuilder":
        self._offer_info.probation_period = probation_period
        return self

    def employee_type_id(self, employee_type_id: str) -> "OfferInfoBuilder":
        self._offer_info.employee_type_id = employee_type_id
        return self

    def employment_type_id(self, employment_type_id: str) -> "OfferInfoBuilder":
        self._offer_info.employment_type_id = employment_type_id
        return self

    def work_email(self, work_email: str) -> "OfferInfoBuilder":
        self._offer_info.work_email = work_email
        return self

    def duration_type_id(self, duration_type_id: str) -> "OfferInfoBuilder":
        self._offer_info.duration_type_id = duration_type_id
        return self

    def signing_type_id(self, signing_type_id: str) -> "OfferInfoBuilder":
        self._offer_info.signing_type_id = signing_type_id
        return self

    def entry_mode(self, entry_mode: str) -> "OfferInfoBuilder":
        self._offer_info.entry_mode = entry_mode
        return self

    def social_security_city_id(self, social_security_city_id: str) -> "OfferInfoBuilder":
        self._offer_info.social_security_city_id = social_security_city_id
        return self

    def contract_type(self, contract_type: str) -> "OfferInfoBuilder":
        self._offer_info.contract_type = contract_type
        return self

    def company(self, company: str) -> "OfferInfoBuilder":
        self._offer_info.company = company
        return self

    def cost_center_rate(self, cost_center_rate: List[JobDataCostCenter]) -> "OfferInfoBuilder":
        self._offer_info.cost_center_rate = cost_center_rate
        return self

    def job_grade_id(self, job_grade_id: str) -> "OfferInfoBuilder":
        self._offer_info.job_grade_id = job_grade_id
        return self

    def custom_fields(self, custom_fields: List[ObjectFieldData]) -> "OfferInfoBuilder":
        self._offer_info.custom_fields = custom_fields
        return self

    def build(self) -> "OfferInfo":
        return self._offer_info
