# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class PatchCostCenterRequestBody(object):
    _types = {
        "effective_time": str,
        "active": bool,
        "operation_reason": str,
    }

    def __init__(self, d=None):
        self.effective_time: Optional[str] = None
        self.active: Optional[bool] = None
        self.operation_reason: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PatchCostCenterRequestBodyBuilder":
        return PatchCostCenterRequestBodyBuilder()


class PatchCostCenterRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._patch_cost_center_request_body = PatchCostCenterRequestBody()

    def effective_time(self, effective_time: str) -> "PatchCostCenterRequestBodyBuilder":
        self._patch_cost_center_request_body.effective_time = effective_time
        return self

    def active(self, active: bool) -> "PatchCostCenterRequestBodyBuilder":
        self._patch_cost_center_request_body.active = active
        return self

    def operation_reason(self, operation_reason: str) -> "PatchCostCenterRequestBodyBuilder":
        self._patch_cost_center_request_body.operation_reason = operation_reason
        return self

    def build(self) -> "PatchCostCenterRequestBody":
        return self._patch_cost_center_request_body
