# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .patch_cost_center_version_request_body import PatchCostCenterVersionRequestBody


class PatchCostCenterVersionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.cost_center_id: Optional[str] = None
        self.version_id: Optional[str] = None
        self.request_body: Optional[PatchCostCenterVersionRequestBody] = None

    @staticmethod
    def builder() -> "PatchCostCenterVersionRequestBuilder":
        return PatchCostCenterVersionRequestBuilder()


class PatchCostCenterVersionRequestBuilder(object):

    def __init__(self) -> None:
        patch_cost_center_version_request = PatchCostCenterVersionRequest()
        patch_cost_center_version_request.http_method = HttpMethod.PATCH
        patch_cost_center_version_request.uri = "/open-apis/corehr/v2/cost_centers/:cost_center_id/versions/:version_id"
        patch_cost_center_version_request.token_types = {AccessTokenType.TENANT}
        self._patch_cost_center_version_request: PatchCostCenterVersionRequest = patch_cost_center_version_request

    def user_id_type(self, user_id_type: str) -> "PatchCostCenterVersionRequestBuilder":
        self._patch_cost_center_version_request.user_id_type = user_id_type
        self._patch_cost_center_version_request.add_query("user_id_type", user_id_type)
        return self

    def cost_center_id(self, cost_center_id: str) -> "PatchCostCenterVersionRequestBuilder":
        self._patch_cost_center_version_request.cost_center_id = cost_center_id
        self._patch_cost_center_version_request.paths["cost_center_id"] = str(cost_center_id)
        return self

    def version_id(self, version_id: str) -> "PatchCostCenterVersionRequestBuilder":
        self._patch_cost_center_version_request.version_id = version_id
        self._patch_cost_center_version_request.paths["version_id"] = str(version_id)
        return self

    def request_body(self, request_body: PatchCostCenterVersionRequestBody) -> "PatchCostCenterVersionRequestBuilder":
        self._patch_cost_center_version_request.request_body = request_body
        self._patch_cost_center_version_request.body = request_body
        return self

    def build(self) -> PatchCostCenterVersionRequest:
        return self._patch_cost_center_version_request
