# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .person_info import PersonInfo


class PatchPersonRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.person_id: Optional[str] = None
        self.request_body: Optional[PersonInfo] = None

    @staticmethod
    def builder() -> "PatchPersonRequestBuilder":
        return PatchPersonRequestBuilder()


class PatchPersonRequestBuilder(object):

    def __init__(self) -> None:
        patch_person_request = PatchPersonRequest()
        patch_person_request.http_method = HttpMethod.PATCH
        patch_person_request.uri = "/open-apis/corehr/v2/persons/:person_id"
        patch_person_request.token_types = {AccessTokenType.TENANT}
        self._patch_person_request: PatchPersonRequest = patch_person_request

    def client_token(self, client_token: str) -> "PatchPersonRequestBuilder":
        self._patch_person_request.client_token = client_token
        self._patch_person_request.add_query("client_token", client_token)
        return self

    def person_id(self, person_id: str) -> "PatchPersonRequestBuilder":
        self._patch_person_request.person_id = person_id
        self._patch_person_request.paths["person_id"] = str(person_id)
        return self

    def request_body(self, request_body: PersonInfo) -> "PatchPersonRequestBuilder":
        self._patch_person_request.request_body = request_body
        self._patch_person_request.body = request_body
        return self

    def build(self) -> PatchPersonRequest:
        return self._patch_person_request
