# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .assessment_for_create import AssessmentForCreate


class PatchProbationAssessmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.client_token: Optional[str] = None
        self.assessment_id: Optional[str] = None
        self.request_body: Optional[AssessmentForCreate] = None

    @staticmethod
    def builder() -> "PatchProbationAssessmentRequestBuilder":
        return PatchProbationAssessmentRequestBuilder()


class PatchProbationAssessmentRequestBuilder(object):

    def __init__(self) -> None:
        patch_probation_assessment_request = PatchProbationAssessmentRequest()
        patch_probation_assessment_request.http_method = HttpMethod.PATCH
        patch_probation_assessment_request.uri = "/open-apis/corehr/v2/probation/assessments/:assessment_id"
        patch_probation_assessment_request.token_types = {AccessTokenType.TENANT}
        self._patch_probation_assessment_request: PatchProbationAssessmentRequest = patch_probation_assessment_request

    def client_token(self, client_token: str) -> "PatchProbationAssessmentRequestBuilder":
        self._patch_probation_assessment_request.client_token = client_token
        self._patch_probation_assessment_request.add_query("client_token", client_token)
        return self

    def assessment_id(self, assessment_id: str) -> "PatchProbationAssessmentRequestBuilder":
        self._patch_probation_assessment_request.assessment_id = assessment_id
        self._patch_probation_assessment_request.paths["assessment_id"] = str(assessment_id)
        return self

    def request_body(self, request_body: AssessmentForCreate) -> "PatchProbationAssessmentRequestBuilder":
        self._patch_probation_assessment_request.request_body = request_body
        self._patch_probation_assessment_request.body = request_body
        return self

    def build(self) -> PatchProbationAssessmentRequest:
        return self._patch_probation_assessment_request
